<?php

class ControllerModulesmslink extends Controller
{
    private $error = array();

    public function index()
    {
        $this->load->language('module/smslink');
        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('setting/setting');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate())
        {        	
            $this->model_setting_setting->editSetting('smslink', $this->request->post);
            $this->session->data['success'] = $this->language->get('text_success');
            $this->response->redirect($this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL'));
        }

        $text_strings = array(
            'heading_title',
            'text_smslink_balance',
            'text_contact_example',
            'text_send_sms',
            'text_admin_alert_customer_checkout',
            'button_save',
            'button_cancel',
            'button_send_sms',
            'entry_smslink_balance',
            'entry_smslink_admin_contact',
            'entry_smslink_username',
            'entry_smslink_password',
            'entry_smslink_admin_alert',
            'order_enabled',
            'order_message',
            'notify_admin',
            'admin_telephone',
        );

        foreach ($text_strings as $text)
            $data[$text] = $this->language->get($text);

        $config_data = array(
            'smslink_username',
            'smslink_password',
            'smslink_notify_admin_value',
            'smslink_admin_telephone_value',
            'smslink_admin_alert_customer_checkout',
            'smslink_order_message_value',
            'smslink_order_enabled_value',
        );

        $this->load->model('localisation/order_status');
        $statuses = new ModelLocalisationOrderStatus($this->registry);
        $statuses = $statuses->getOrderStatuses();
        $data['statuses'] = $statuses;

        foreach ($statuses as $key => $status)
        {
            $config_data[] = 'smslink_message_of_order_status_'.$status["order_status_id"];
            $config_data[] = 'smslink_order_status_'.$status["order_status_id"].'_enabled';
        }

        foreach ($config_data as $conf) {
            if (isset($this->request->post[$conf])) {
                $data[$conf] = $this->request->post[$conf];
            } else {                
                $data[$conf] = $this->config->get($conf);
            }
        }

        if($data['smslink_username'] == "" || $data['smslink_password'] == "")
        {
            $data['smslink_balance'] = $data['text_smslink_balance'];
        }
        else
        {
            require_once(DIR_SYSTEM . 'library/smslink.php');
            $smslink = new smslink;
            $smslink->setApi($data['smslink_username'], $data['smslink_password']);
            $data['smslink_balance'] = $smslink->smslink_balance();
        }

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text'      => $this->language->get('text_home'),
            'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
            'separator' => false
        );

        $data['breadcrumbs'][] = array(
            'text'      => $this->language->get('text_module'),
            'href'      => $this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL'),
            'separator' => ' :: '
        );

        $data['breadcrumbs'][] = array(
            'text'      => $this->language->get('heading_title'),
            'href'      => $this->url->link('module/smslink', 'token=' . $this->session->data['token'], 'SSL'),
            'separator' => ' :: '
        ); 

        $data['action'] = $this->url->link('module/smslink', 'token=' . $this->session->data['token'], 'SSL');

        $data['cancel'] = $this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL');        
        $data['send_sms'] = $this->url->link('module/smslink', 'token=' . $this->session->data['token'], 'SSL');

        $data['modules'] = array();

        if (isset($this->request->post['smslink_module'])) {
            $data['modules'] = $this->request->post['smslink_module'];
        } elseif ($this->config->get('smslink_module')) {
            $data['modules'] = $this->config->get('smslink_module');  
        }

        $this->load->model('design/layout');

        $data['layouts'] = $this->model_design_layout->getLayouts(); 

        $data['column_left'] = $this->load->controller('common/column_left');
        $data['column_right'] = $this->load->controller('common/column_right');
        $data['content_top'] = $this->load->controller('common/content_top');
        $data['content_bottom'] = $this->load->controller('common/content_bottom'); 
        $data['header'] = $this->load->controller('common/header');        
        $data['footer'] = $this->load->controller('common/footer');
        
        $this->response->setOutput($this->load->view('module/smslink.tpl', $data));

    }

    public function install()
    {

    }

    public function uninstall()
    {

    }

    private function validate()
    {
        if (!$this->user->hasPermission('modify', 'module/smslink'))
        {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        if (!$this->error)
        {
            return TRUE;
        }
        else
        {
            return FALSE;
        }

    }

    public function verify_api()
    {
        require_once(DIR_SYSTEM . 'library/smslink.php');
        $smslink = new smslink;

        $username = $_REQUEST['user'];
        $password = $_REQUEST['pass'];

        if ((strlen($username) > 0) and (strlen($username) > 0))
        {
            $response = $smslink->smslink_balance($username, $password, 1);

            echo "Numarul de SMS-uri disponibile in contul dvs. de utilizator: ".$response;
        }
        else
        {
            echo "Introduceti Connection ID si Parola asociate serviciului SMS Gateway din contul dvs. SMSLink.";

        }

    }

}
?>