<?php

use Tygh\Registry;
use Tygh\Settings;
use Tygh\Tools\DateTimeHelper;
require_once (Registry::get('config.dir.addons') ."smslink/api/smslink.php");

if (!defined('BOOTSTRAP')) 
{ 
    die('Access denied'); 
}

function fn_smslink_change_order_status_post($order_id, $status_to, $status_from, $order_info, $force_notification, $order_statuses, $place_order)
{
    if (($status_to != $status_from && $status_from != 'N') || 
        ($status_from == 'N' && empty($order_info))
       )
    {
        $replaceLimit = 1;
        
        $phone = str_replace("+", "00", $order_statuses["phone"], $replaceLimit);
        $phone = preg_replace("/[^0-9]/", "", $phone);        

        $orderStatuses = array(
                "P" => "paid",
                "C" => "complete",
                "O" => "open",
                "F" => "failed",
                "D" => "declined",
                "B" => "backordered",
                "I" => "canceled",
                "Y" => "awaiting_call",
                "N" => "incomplete"
            );
        
        $orderVariabiles = array(
                "{order_id}"           => $order_id,
                "{order_total}"        => number_format($order_statuses['total'], 2, ',', ''),
                "{order_date}"         => date('d-m-Y', $order_statuses['timestamp']),
                "{customer_firstname}" => $order_statuses['firstname'],
                "{customer_lastname}"  => $order_statuses['lastname'],
                "{customer_notes}"     => trim(preg_replace('/\s\s+/', ' ', $order_statuses['notes'])),
                "{staff_notes}"        => trim(preg_replace('/\s\s+/', ' ', $order_statuses['details'])),
                "{shipments_list}"     => "",
            );       
        
        $ShipmentsIDs = array();
        $CustomerShipments = array();
        
        if (isset($order_statuses['shipment_ids']))
        {
            $ShipmentsIDs = $order_statuses['shipment_ids'];

            if (is_array($ShipmentsIDs))
            {
                foreach ($ShipmentsIDs as $Key => $ShipmentsID)
                {
                    $ShipmentData = db_get_array("SELECT * FROM ?:shipments WHERE `shipment_id` = '".$ShipmentsID."' LIMIT 1");
                    
                    if (isset($ShipmentData[0]))
                        $CustomerShipments[] = $ShipmentData[0]["tracking_number"]." (".strtoupper($ShipmentData[0]["carrier"]).")";                                            
                }                
            }            
        }                
        
        $orderVariabiles["{shipments_list}"] = implode(", ", $CustomerShipments);
        
        if (Registry::get('addons.smslink.' . $orderStatuses[$status_to] . '-validation') == "Y")
        {
            $message = Registry::get('addons.smslink.' . $orderStatuses[$status_to] . '-message');
            
            if (strlen($message) > 0)
            {
                if (strlen($phone) > 0)
                {
                    foreach($orderVariabiles as $key => $value)                    
                        $message = str_replace($key, $value, $message);                    
                    
                    if ((strlen(Registry::get('addons.smslink.smslink-connection-id')) > 0) and (strlen(Registry::get('addons.smslink.smslink-password')) > 0))
                    {
                        $SMSLinkSMSGateway = new SMSLinkSMSGateway(
                                trim(Registry::get('addons.smslink.smslink-connection-id')),
                                trim(Registry::get('addons.smslink.smslink-password'))
                            );       
                    }
                    else
                    {   
                        $historyLog = array(
                            'remote_message_id' => 0,
                            'datetime'          => date('Y-m-d H:i:s', time()),
                            'phone'             => $phone,
                            'message'           => $message,                                
                            'result'            => 'Connection ID or Password is blank. Please configure SMSLink addon.',
                        );
                        
                        db_query('INSERT INTO ?:smslink_history ?e', $historyLog);
                        
                        if ($_SESSION['auth']['user_type'] === 'A')
                            fn_set_notification('W', "SMSLink", "Unable to connect to SMSLink, Connection ID or Password is blank. Please configure SMSLink addon.", 'K');                                              
                        
                        return false;
                    }
                   
                    $messageId = $SMSLinkSMSGateway->sendMessage($phone, $message);                    

                    $historyLog = array(
                            'remote_message_id' => $messageId,
                            'datetime'          => date('Y-m-d H:i:s', time()),
                            'phone'             => $phone,
                            'message'           => $message,
                            'result'            => $SMSLinkSMSGateway->getLastLogMessage(),
                        );
                    
                    db_query('INSERT INTO ?:smslink_history ?e', $historyLog);
                    
                    if ($messageId !== false)
                    {
                        if($_SESSION['auth']['user_type'] === 'A')
                            fn_set_notification('N', "SMSLink", "Message succesfuly sent.", 'K'); 
                        
                    } 
                    else 
                    {                        
                        if($_SESSION['auth']['user_type'] === 'A')
                            fn_set_notification('W', "SMSLink", "Error occured when sending SMS (".$SMSLinkSMSGateway->getLastLogMessage().").", 'K');
                                               
                    }
                    
                }
                else
                {
                    $historyLog = array(
                            'remote_message_id' => 0,
                            'datetime'          => date('Y-m-d H:i:s', time()),
                            'phone'             => $phone,
                            'message'           => $message,
                            'result'            => 'Unable to send SMS. Phone number is blank for this order.',
                    );
                    
                    db_query('INSERT INTO ?:smslink_history ?e', $historyLog);
                    
                    if ($_SESSION['auth']['user_type'] === 'A')
                        fn_set_notification('W', "SMSLink", "Unable to send SMS. Phone number is blank for this order.", 'K');
                }
                
            }
            else
            {
                $historyLog = array(
                        'remote_message_id' => 0,
                        'datetime'          => date('Y-m-d H:i:s', time()),
                        'phone'             => $phone,
                        'message'           => $message,
                        'result'            => 'Unable to send SMS. SMS template is empty for this order status. Please configure SMS templates in SMSLink addon.',
                    );
                
                db_query('INSERT INTO ?:smslink_history ?e', $historyLog);
                
                if ($_SESSION['auth']['user_type'] === 'A')
                    fn_set_notification('W', "SMSLink", "Unable to send SMS. SMS template is empty for this order status. Please configure SMS templates in SMSLink addon.", 'K');
                
            }
            
        }
                
    }
    
}

function fn_smslink_populate_history()
{
    $extra_query = "";
    
    $phone = "";
    if (isset($_GET['phone']))
        $phone = trim($_GET['phone']);
    
    $date = "";
    if (isset($_GET['date']))
        $date  = trim($_GET['date']);

    $sqlFilters = "";
    if ((strlen($phone) > 0) or (strlen($date) > 0))
        $sqlFilters = ' WHERE `phone` LIKE "%'.$phone .'%" AND `datetime` LIKE "%'.$date.'%"';
    
    $search = array(
        'page'           => isset($_REQUEST['page'])           ? $_REQUEST['page']           : 1,
        'items_per_page' => isset($_REQUEST['items_per_page']) ? $_REQUEST['items_per_page'] : Registry::get('settings.Appearance.admin_elements_per_page'),
        'total_items'    => db_query('SELECT COUNT(*) from ?:smslink_history'.$sqlFilters)->fetch_all()[0][0]
    );
    
    $startIndex = ($search['page'] - 1) * $search['items_per_page'];
    
    $entries = db_query('SELECT * 
                          FROM ?:smslink_history'.
                          $sqlFilters.'
                      ORDER BY `local_message_id` DESC 
                         LIMIT ?i, ?i', 
                        $startIndex, 
                        $search['items_per_page']
                )->fetch_all();

    return array($entries, $search);
}
