<?php

if (!defined('BOOTSTRAP')) 
{ 
    die('Access denied'); 
}

function fn_add_textarea_variabiles()
{
    ob_start();
    
    ?>
        <p>   
            Variabiles available for SMS templates:
              
            <style>
    
                ul.SMSTemplates { clear: both; margin: 0; padding: 10px 0 10px 0; border: 1px #EAEAEA solid; border-radius: 10px; background: #FAFAFA; }
                ul.SMSTemplates li { clear: both; margin: 0 0 0 40px; padding: 0; }
                
            </style>
              
            <ul class="SMSTemplates">          
                <li><a onclick="placeInFocusedTextarea('{order_id}');">{order_id}</a> - Order ID</li> 
                <li><a onclick="placeInFocusedTextarea('{order_total}');">{order_total}</a> - Order Total (number, without currency)</li> 
                <li><a onclick="placeInFocusedTextarea('{order_date}');">{order_date}</a> - Order Date (dd-mm-yyyy)</li>
                <li><a onclick="placeInFocusedTextarea('{customer_firstname}');">{customer_firstname}</a> - Customer First Name</li>
                <li><a onclick="placeInFocusedTextarea('{customer_lastname}');">{customer_lastname}</a> - Customer Last Name</li>
                <li><a onclick="placeInFocusedTextarea('{customer_notes}');">{customer_notes}</a> - Customer Notes</li>
                <li><a onclick="placeInFocusedTextarea('{staff_notes}');">{staff_notes}</a> - Staff Only Notes</li>
                <li><a onclick="placeInFocusedTextarea('{shipments_list}');">{shipments_list}</a> - Shipments List, Tracking Number (Carrier)</li>                
            </ul>
            
            <script>
            
                var focused;

                document.addEventListener("DOMContentLoaded", (event) => {
                    var inputs = document.getElementsByTagName("textarea");
                    for (var i = 0, input; i < inputs.length && (input = inputs[i]); i++) {
                        input.addEventListener("focus", function(){
                            focused = this;
                        });
                    }
                });
                
                function placeInFocusedTextarea(textToAdd)
                {
                    if(focused)
                    {
                        focused.value += textToAdd;
                        lengthCounter(focused, focused.previousSibling);
                    }
                }
                        
            </script>
        </p>    
    <?php 
    
    $scriptContent = ob_get_contents();    
    ob_end_clean();
    
    return $scriptContent;    
}

function fn_add_textarea_length_counter()
{
    ob_start();
    
    ?>       
    <script>
    
        var focused;
        
        document.addEventListener("DOMContentLoaded", (event) => {

            var textareaList = document.getElementsByTagName("textarea");

            for (var i = 0, textarea; i < textareaList.length && (textarea = textareaList[i]); i++) 
            {
                var counter = document.createElement("div");
                counter.textContent = "";
                
                var widthToSet = textarea.offsetWidth;
                var width = window.getComputedStyle(textarea, null).width;

                counter.setAttribute("style", "text-align: right; padding-bottom: 1em; width: " + width);
                textarea.parentNode.insertBefore(counter, textarea);
                
                textarea.addEventListener("input", (event) => 
                {
                    lengthCounter(event.target || event.srcElement, event.target.previousSibling || event.srcElement.previousSibling);
                });
                
                textarea.addEventListener("change", (event) => 
                {
                    lengthCounter(event.target || event.srcElement, event.target.previousSibling || event.srcElement.previousSibling);
                });
                
                lengthCounter(textarea, counter);
            }
        });

        function lengthCounter(textarea, counter)
        {
            var lengthCharacters = textarea.value.length;
            var lengthMessages = (lengthCharacters <= 160) ? 1 : Math.ceil(lengthCharacters / 152);      
            
            if (lengthCharacters > 0) counter.textContent = "SMS template length: " + lengthCharacters + ' characters, ' + lengthMessages + " SMS";            
            else counter.textContent = "SMS template is blank";            
        }
        
    </script>
    <?php 
    
    $scriptContent = ob_get_contents();    
    ob_end_clean();
    
    return $scriptContent;    
}