<?php



namespace SMSLink\SMSGateway\Observer;



use Magento\Framework\Event\ObserverInterface;

use \Magento\Framework\Event\Observer       as Observer;

use \Magento\Framework\View\Element\Context as Context;

use \SMSLink\SMSGateway\Helper\Data         as Helper;



if (!class_exists('SaveAfter')) 

{

    class SaveAfter implements ObserverInterface

    {

        const AJAX_PARAM_NAME = 'infscroll';

        const AJAX_HANDLE_NAME = 'infscroll_ajax_request';



        protected $_request;

        protected $_layout;

        protected $_cache;

        protected $_helper;



        protected $username;

        protected $password;

        protected $destination;

        protected $message;

    

        public function __construct(Context $context, Helper $helper) 

        {

            $this->_helper  = $helper;

            $this->_request = $context->getRequest();

            $this->_layout  = $context->getLayout();

            

        }

    

        public function execute(Observer $observer)

        {          

            $this->_helper->EventsLog("SaveAfter -> Execute Started");

            

            $this->_helper->EventsLog("SaveAfter -> REQUEST_URI: ".$_SERVER['REQUEST_URI']);

            

            $accepted_statuses = array(

                    "order/cancel",

                    "order/hold",

                    "order/unhold",

                    "order_invoice/save",

                    "order_shipment/save"

                );

            

            $found_status = null;

            foreach ($accepted_statuses as $key => $accepted_status)

                if (strpos($_SERVER['REQUEST_URI'], $accepted_status) !== false) 

                    $found_status = $accepted_status;

            

            if (!is_null($found_status))

            {

                $this->_helper->EventsLog("SaveAfter -> Found Status: ".$found_status);

                

                $this->username = $this->_helper->SMSGatewayConnectionID();

                $this->password = $this->_helper->SMSGatewayPassword();

                

                $this->message = $this->_helper->getCustomerMessage($found_status);

                $this->_helper->EventsLog("SaveAfter -> Message[Template]: ".$this->message);

                

                if ($this->_helper->isCustomerMessageEnabled($found_status) == 1)

                {

                    $order  = $this->_helper->getOrder($observer);

                    

                    $order_awb_list = array();

                    foreach ($order->getTracksCollection() as $track)

                        if (!$track->isDeleted())

                            $order_awb_list[] = $track->getTitle().", AWB: ".$track->getNumber();

                    

                    $order_awb_list = implode(", ", $order_awb_list);

                    

                    $this->_helper->EventsLog("SaveAfter -> AWB List: ".var_export($order_awb_list, true));

                    

                    $orderData = array(

                            'orderid'    => $order->getIncrementId(),

                            'fname'      => $order->getCustomerFirstname(),

                            'mname'      => $order->getCustomerMiddlename(),

                            'lname'      => $order->getCustomerLastname(),

                            'ordertotal' => number_format($order->getGrandTotal(), 2),

                            'awb'        => $order_awb_list

                        );                                                

                    

                    $this->destination  = $order->getBillingAddress()->getTelephone();

                    $this->_helper->EventsLog("SaveAfter -> Destination: ".$this->destination);

                    

                    $this->message      = $this->_helper->ParseMessageText($this->message, $orderData);

                    $this->_helper->EventsLog("SaveAfter -> Message[Parsed]: ".$this->message);

                    

                    $this->_helper->SendSMS(

                            $this->username,

                            $this->password,

                            $this->destination,

                            $this->message

                        );

                        

                }

                

                $this->_helper->EventsLog("SaveAfter -> Execute Ended");

                

            }

            

        }

        

    }

    

}

