<?php
class ControllerExtensionModuleSmslink extends Controller {

    private $error = array();

    public function index()
    {
        $this->load->language('extension/module/smslink');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('setting/setting');
        $this->load->model('design/layout');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
            $this->model_setting_setting->editSetting('module_smslink', $this->request->post);

            $this->session->data['success'] = $this->language->get('text_success');

            $this->response->redirect($this->url->link('extension/extension', 'token=' . $this->session->data['token'] . '&type=module', true));
        }

        $data['heading_title'] = $this->language->get('heading_title');

        $data['text_edit'] = $this->language->get('text_edit');
        $data['text_enabled'] = $this->language->get('text_enabled');
        $data['text_disabled'] = $this->language->get('text_disabled');

        $data['entry_status'] = $this->language->get('entry_status');
        $data['entry_username'] = $this->language->get('entry_username');
        $data['entry_password'] = $this->language->get('entry_password');
        $data['entry_label'] = $this->language->get('entry_label');
        $data['entry_simulation'] = $this->language->get('entry_simulation');
        $data['entry_simulation_phone'] = $this->language->get('entry_simulation_phone');
        $data['entry_message'] = $this->language->get('entry_message');
        $data['entry_yes'] = $this->language->get('entry_yes');
        $data['entry_no'] = $this->language->get('entry_no');
        $data['entry_characters_left'] = $this->language->get('entry_characters_left');
        $data['entry_available_vars'] = $this->language->get('entry_available_vars');

        $data['button_save'] = $this->language->get('button_save');
        $data['button_cancel'] = $this->language->get('button_cancel');

        # get list of order statuses
        $this->load->model('localisation/order_status');
        $statuses = new ModelLocalisationOrderStatus($this->registry);
        $statuses = $statuses->getOrderStatuses();
        $data['statuses'] = $statuses;

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        $data['breadcrumbs'] = array();
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], true)
        );
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_module'),
            'href' => $this->url->link('marketplace/extension', 'token=' . $this->session->data['token'] . '&type=module', true)
        );
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('extension/module/smslink', 'token=' . $this->session->data['token'], true)
        );

        $data['action'] = $this->url->link('extension/module/smslink', 'token=' . $this->session->data['token'], true);
        $data['cancel'] = $this->url->link('marketplace/extension', 'token=' . $this->session->data['token'] . '&type=module', true);

        $data['token'] = $this->session->data['token'];

        # form
        if (isset($this->request->post['module_smslink_status'])) {
            $data['module_smslink_status'] = $this->request->post['module_smslink_status'];
        } else {
            $data['module_smslink_status'] = $this->config->get('module_smslink_status');
        }
        if (isset($this->request->post['module_smslink_username'])) {
            $data['smslink_username'] = $this->request->post['module_smslink_username'];
        } elseif ($this->config->get('module_smslink_username')) {
            $data['smslink_username'] = $this->config->get('module_smslink_username');
        } else {
            $data['smslink_username'] = '';
        }
        if (isset($this->request->post['module_smslink_password'])) {
            $data['smslink_password'] = $this->request->post['module_smslink_password'];
        } elseif ($this->config->get('module_smslink_password')) {
            $data['smslink_password'] = $this->config->get('module_smslink_password');
        } else {
            $data['smslink_password'] = '';
        }
        if (isset($this->request->post['module_smslink_simulation'])) {
            $data['smslink_simulation'] = $this->request->post['module_smslink_simulation'];
        } elseif ($this->config->get('module_smslink_simulation')) {
            $data['smslink_simulation'] = $this->config->get('module_smslink_simulation');
        } else {
            $data['smslink_simulation'] = '';
        }
        if (isset($this->request->post['module_smslink_simulation_phone'])) {
            $data['smslink_simulation_phone'] = $this->request->post['module_smslink_simulation_phone'];
        } elseif ($this->config->get('module_smslink_simulation_phone')) {
            $data['smslink_simulation_phone'] = $this->config->get('module_smslink_simulation_phone');
        } else {
            $data['smslink_simulation_phone'] = '';
        }
        foreach ($statuses as $status) {
            if (isset($this->request->post['module_smslink_message_'.$status['order_status_id']])) {
                $data['smslink_message_'.$status['order_status_id']] = $this->request->post['module_smslink_message_'.$status['order_status_id']];
            } elseif ($this->config->get('module_smslink_message_'.$status['order_status_id'])) {
                $data['smslink_message_'.$status['order_status_id']] = $this->config->get('module_smslink_message_'.$status['order_status_id']);
            } else {
                $data['smslink_message_'.$status['order_status_id']] = '';
            }
        }

        $data['history_link'] = $this->url->link('smslink/history', 'token=' . $this->session->data['token'], true);
        $data['history_text'] = $this->language->get('text_history');
        $data['about_link'] = $this->url->link('smslink/about', 'token=' . $this->session->data['token'], true);
        $data['about_text'] = $this->language->get('text_about');
        $data['test_link'] = $this->url->link('smslink/test', 'token=' . $this->session->data['token'], true);
        $data['test_text'] = $this->language->get('text_test');

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('extension/module/smslink', $data));
    }

    protected function validate()
    {
        if (!$this->user->hasPermission('modify', 'extension/module/smslink')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        return !$this->error;
    }

    public function install()
    {
        $this->load->model('extension/smslink/history');
        $this->model_extension_smslink_history->createSchema();
        $this->load->model('extension/event');
        $this->model_extension_event->addEvent('smslink', 'catalog/model/checkout/order/addOrderHistory/before', 'extension/module/smslink/status_change');

        $this->load->model('user/user_group');

        $this->model_user_user_group->addPermission($this->user->getGroupId(), 'access', 'smslink/about');
        $this->model_user_user_group->addPermission($this->user->getGroupId(), 'access', 'smslink/history');
        $this->model_user_user_group->addPermission($this->user->getGroupId(), 'access', 'smslink/test');
    }

    public function uninstall()
    {
        $this->load->model('extension/smslink/history');
        $this->model_extension_smslink_history->deleteSchema();
        $this->load->model('extension/event');
        $this->model_extension_event->deleteEvent('smslink');

        $this->load->model('user/user_group');

        $this->model_user_user_group->removePermission($this->user->getGroupId(), 'access', 'smslink/about');
        $this->model_user_user_group->removePermission($this->user->getGroupId(), 'access', 'smslink/history');
        $this->model_user_user_group->removePermission($this->user->getGroupId(), 'access', 'smslink/test');
    }
}
